SuperStrict

' Example 5: SAPI XML Markup
' Demonstrates: SPF_IS_XML, rate/pitch/volume/silence tags

Framework BRL.StandardIO

Import "-L."
Import "-lBlitzSpeech"
Include "BlitzSpeechH.bmx"

Print "BlitzSpeech - SAPI XML Markup Example"

Print ""

If InitSpeech() = SP_INIT_SUCCESS Then
    Local text:String = "The quick brown fox pumps in a hedgehogs face."
    
    Print "--- RATE CONTROL (SAPI XML) ---"
    Print ""
    
    Print "Very slow (rate: -10)"
    SpeakTextFlags("<rate absspeed=~q-10~q>" + text + "</rate>", SPF_IS_XML)
    Delay(1000)
    
    Print "Very fast (rate: 10)"
    SpeakTextFlags("<rate absspeed=~q10~q>" + text + "</rate>", SPF_IS_XML)
    Delay(1000)
    Print ""
    
    Print "--- PITCH CONTROL (SAPI XML) ---"
    Print ""
    
    Print "Low pitch (-10)"
    SpeakTextFlags("<pitch absmiddle=~q-10~q>" + text + "</pitch>", SPF_IS_XML)
    Delay(1000)
    
    Print "High pitch (10)"
    SpeakTextFlags("<pitch absmiddle=~q10~q>" + text + "</pitch>", SPF_IS_XML)
    Delay(1000)
    Print ""
    
    Print "--- VOLUME CONTROL (SAPI XML) ---"
    Print ""
    
    Print "Quiet (volume: 20)"
    SpeakTextFlags("<volume level=~q20~q>" + text + "</volume>", SPF_IS_XML)
    Delay(1000)
    
    Print "Loud (volume: 100)"
    SpeakTextFlags("<volume level=~q100~q>" + text + "</volume>", SPF_IS_XML)
    Delay(1000)
    Print ""
    
    Print "--- PAUSES (SAPI XML) ---"
    Print ""
    
    Print "2 second pause between words"
    SpeakTextFlags("Hello<silence msec=~q2000~q/>world", SPF_IS_XML)
    Delay(1000)
    Print ""
    
    Print "--- COMBINED EFFECTS ---"
    Print ""
    
    Print "Robot voice (slow + low pitch)"
    SpeakTextFlags("<rate absspeed=~q-10~q><pitch absmiddle=~q-10~q>" + text + "</pitch></rate>", SPF_IS_XML)
    Delay(1000)
    
    Print "Chipmunk voice (fast + high pitch)"
    SpeakTextFlags("<rate absspeed=~q10~q><pitch absmiddle=~q10~q>" + text + "</pitch></rate>", SPF_IS_XML)
    Delay(1000)
    Print ""
    
    CleanupSpeech()
    Print "Done!"
Else
    Print "Failed to initialize speech!"
EndIf

Print ""
Print "Press ENTER to exit..."
Input ""